<?php

declare(strict_types=1);

namespace App\Model;

use Nette;
use Nette\Security;

class Authenticator implements Security\Authenticator
{
	public function __construct(
		private Nette\Database\Explorer $database,
		private Security\Passwords $passwords,
	) {
	}

	public function authenticate(string $username, string $password): Security\SimpleIdentity
	{
		$row = $this->database->table('users')->where('username', $username)->fetch();

		if (!$row) {
			throw new Security\AuthenticationException('Nesprávné uživatelské jméno.', self::IdentityNotFound);
		} elseif (!$this->passwords->verify($password, $row->password)) {
			throw new Security\AuthenticationException('Nesprávné heslo.', self::InvalidCredential);
		} elseif (!$row->active) {
			throw new Security\AuthenticationException('Účet je deaktivován.', self::NotApproved);
		}

		$arr = $row->toArray();
		unset($arr['password']);
		return new Security\SimpleIdentity($row->id, $row->role ?? 'admin', $arr);
	}
}
