<?php

declare(strict_types=1);

namespace App\Model;

use Nette;

class MessageRepository
{
	public function __construct(
		private Nette\Database\Explorer $database,
	) {
	}

	public function findAll(): Nette\Database\Table\Selection
	{
		return $this->database->table('messages')->order('created_at DESC');
	}

	public function findById(int $id): ?Nette\Database\Table\ActiveRow
	{
		return $this->findAll()->get($id);
	}

	public function insert(array $values): Nette\Database\Table\ActiveRow
	{
		return $this->database->table('messages')->insert($values);
	}

	public function markAsRead(int $id): void
	{
		$this->database->table('messages')
			->where('id', $id)
			->update(['is_read' => 1]);
	}

	public function countUnread(): int
	{
		return $this->database->table('messages')
			->where('is_read', 0)
			->count('*');
	}
}
