<?php

declare(strict_types=1);

namespace App\Model;

use Nette;

class UserRepository
{
	public function __construct(
		private Nette\Database\Explorer $database,
	) {
	}

	public function findAll(): Nette\Database\Table\Selection
	{
		return $this->database->table('users');
	}

	public function findById(int $id): ?Nette\Database\Table\ActiveRow
	{
		return $this->findAll()->get($id) ?: null;
	}
}
