-- InesDrive Servis – database schema

-- Admin users
CREATE TABLE IF NOT EXISTS users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    username TEXT NOT NULL UNIQUE,
    password TEXT NOT NULL,
    realname TEXT,
    role TEXT NOT NULL DEFAULT 'admin',
    active INTEGER NOT NULL DEFAULT 1,
    created_at TEXT NOT NULL DEFAULT (datetime('now', 'localtime'))
);

-- Service categories
CREATE TABLE IF NOT EXISTS service_categories (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    icon TEXT NOT NULL DEFAULT '🔧',
    weight INTEGER NOT NULL DEFAULT 0,
    active INTEGER NOT NULL DEFAULT 1
);

-- Individual services (belong to a category)
CREATE TABLE IF NOT EXISTS services (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    category_id INTEGER NOT NULL,
    name TEXT NOT NULL,
    description TEXT,
    price_from TEXT,
    weight INTEGER NOT NULL DEFAULT 0,
    active INTEGER NOT NULL DEFAULT 1,
    FOREIGN KEY (category_id) REFERENCES service_categories(id)
);

-- Customer bookings / reservations
CREATE TABLE IF NOT EXISTS bookings (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    service_id INTEGER,
    service_text TEXT,
    preferred_date TEXT,
    preferred_time TEXT,
    name TEXT NOT NULL,
    email TEXT,
    phone TEXT NOT NULL,
    car_info TEXT,
    note TEXT,
    status TEXT NOT NULL DEFAULT 'new',
    created_at TEXT NOT NULL DEFAULT (datetime('now', 'localtime')),
    FOREIGN KEY (service_id) REFERENCES services(id)
);

-- Contact form messages
CREATE TABLE IF NOT EXISTS messages (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    subject TEXT NOT NULL,
    name TEXT NOT NULL,
    email TEXT NOT NULL,
    phone TEXT NOT NULL,
    message TEXT NOT NULL,
    is_read INTEGER NOT NULL DEFAULT 0,
    created_at TEXT NOT NULL DEFAULT (datetime('now', 'localtime'))
);

-- Newsletter subscribers
CREATE TABLE IF NOT EXISTS emails (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    realname TEXT,
    email TEXT NOT NULL UNIQUE,
    active INTEGER NOT NULL DEFAULT 0,
    verified INTEGER NOT NULL DEFAULT 0,
    token TEXT,
    created_at TEXT NOT NULL DEFAULT (datetime('now', 'localtime'))
);

-- Audit log
CREATE TABLE IF NOT EXISTS audit_log (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    action TEXT NOT NULL,
    ip TEXT,
    user_agent TEXT,
    data TEXT,
    detail TEXT,
    created_at TEXT NOT NULL DEFAULT (datetime('now', 'localtime'))
);


-- =============================================
-- SEED DATA
-- =============================================

-- Default admin user (password: admin123 – hashed via Nette\Security\Passwords)
-- The hash will be created on first run via a setup script
INSERT INTO users (username, password, realname, role) VALUES ('admin', '$2y$10$placeholder', 'Administrátor', 'admin');

-- Service categories
INSERT INTO service_categories (name, icon, weight) VALUES ('Základní mechanické práce', '🔧', 1);
INSERT INTO service_categories (name, icon, weight) VALUES ('Diagnostika a elektro', '💻', 2);
INSERT INTO service_categories (name, icon, weight) VALUES ('Klimatizace', '❄️', 3);
INSERT INTO service_categories (name, icon, weight) VALUES ('Pneuservis', '🚗', 4);
INSERT INTO service_categories (name, icon, weight) VALUES ('STK a administrativa', '📋', 5);
INSERT INTO service_categories (name, icon, weight) VALUES ('Další služby', '✨', 6);

-- Services: Základní mechanické práce (cat 1)
INSERT INTO services (category_id, name, weight) VALUES (1, 'Výměna oleje a filtrů', 1);
INSERT INTO services (category_id, name, weight) VALUES (1, 'Výměna brzd (destičky, kotouče)', 2);
INSERT INTO services (category_id, name, weight) VALUES (1, 'Opravy podvozku (tlumiče, ramena, čepy)', 3);
INSERT INTO services (category_id, name, weight) VALUES (1, 'Rozvody (řemen, řetěz)', 4);
INSERT INTO services (category_id, name, weight) VALUES (1, 'Spojky', 5);
INSERT INTO services (category_id, name, weight) VALUES (1, 'Výfuky', 6);
INSERT INTO services (category_id, name, weight) VALUES (1, 'Chlazení motoru (chladiče, termostaty)', 7);
INSERT INTO services (category_id, name, weight) VALUES (1, 'Motorové opravy menšího rozsahu', 8);
INSERT INTO services (category_id, name, weight) VALUES (1, 'Výměna autobaterií', 9);
INSERT INTO services (category_id, name, weight) VALUES (1, 'Servis převodovek (manuální)', 10);

-- Services: Diagnostika a elektro (cat 2)
INSERT INTO services (category_id, name, weight) VALUES (2, 'Napojení na OBD diagnostiku', 1);
INSERT INTO services (category_id, name, weight) VALUES (2, 'Mazání chybových hlášek', 2);
INSERT INTO services (category_id, name, weight) VALUES (2, 'Kontrola řídících jednotek', 3);
INSERT INTO services (category_id, name, weight) VALUES (2, 'Elektroinstalace (světla, startér, alternátor)', 4);
INSERT INTO services (category_id, name, weight) VALUES (2, 'Parkovací senzory', 5);
INSERT INTO services (category_id, name, weight) VALUES (2, 'Kamery', 6);
INSERT INTO services (category_id, name, weight) VALUES (2, 'Montáž autorádií', 7);
INSERT INTO services (category_id, name, weight) VALUES (2, 'Tažná zařízení (včetně elektroinstalace)', 8);

-- Services: Klimatizace (cat 3)
INSERT INTO services (category_id, name, weight) VALUES (3, 'Plnění klimatizace', 1);
INSERT INTO services (category_id, name, weight) VALUES (3, 'Dezinfekce', 2);
INSERT INTO services (category_id, name, weight) VALUES (3, 'Čištění okruhu', 3);
INSERT INTO services (category_id, name, weight) VALUES (3, 'Detekce úniku chladiva', 4);
INSERT INTO services (category_id, name, weight) VALUES (3, 'Výměna kompresoru', 5);

-- Services: Pneuservis (cat 4)
INSERT INTO services (category_id, name, weight) VALUES (4, 'Přezouvání pneu', 1);
INSERT INTO services (category_id, name, weight) VALUES (4, 'Vyvažování kol', 2);
INSERT INTO services (category_id, name, weight) VALUES (4, 'Opravy defektů', 3);
INSERT INTO services (category_id, name, weight) VALUES (4, 'Prodej pneumatik', 4);
INSERT INTO services (category_id, name, weight) VALUES (4, 'Sezónní uskladnění kol', 5);
INSERT INTO services (category_id, name, weight) VALUES (4, 'Kontrola tlaku TPMS', 6);

-- Services: STK a administrativa (cat 5)
INSERT INTO services (category_id, name, weight) VALUES (5, 'Příprava na STK', 1);
INSERT INTO services (category_id, name, weight) VALUES (5, 'Emise', 2);
INSERT INTO services (category_id, name, weight) VALUES (5, 'Zajištění STK za zákazníka', 3);
INSERT INTO services (category_id, name, weight) VALUES (5, 'Servisní knížky', 4);
INSERT INTO services (category_id, name, weight) VALUES (5, 'Pojišťovací opravy', 5);
INSERT INTO services (category_id, name, weight) VALUES (5, 'Komunikace s pojišťovnou', 6);

-- Services: Další služby (cat 6)
INSERT INTO services (category_id, name, weight) VALUES (6, 'Výměna čelního skla', 1);
INSERT INTO services (category_id, name, weight) VALUES (6, 'Opravy prasklin', 2);
INSERT INTO services (category_id, name, weight) VALUES (6, 'Leštění světlometů', 3);
INSERT INTO services (category_id, name, weight) VALUES (6, 'Čištění interiéru', 4);
INSERT INTO services (category_id, name, weight) VALUES (6, 'Drobné lakýrnické práce', 5);
INSERT INTO services (category_id, name, weight) VALUES (6, 'Montáž doplňků (nosiče, boxy)', 6);
INSERT INTO services (category_id, name, weight) VALUES (6, 'Základní detailing', 7);
