#!/usr/bin/env php
<?php

/**
 * Initialize the InesDrive database and admin user.
 * Usage: php scripts/setup.php
 */

$dbFile = __DIR__ . '/../data/database.sqlite';
$schemaFile = __DIR__ . '/../data/schema.sql';

echo "InesDrive Setup\n";
echo "===============\n\n";

// Create database
$db = new PDO("sqlite:$dbFile");
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

echo "📦 Creating database tables...\n";
$sql = file_get_contents($schemaFile);

// Execute entire SQL file at once using exec
try {
    $db->exec($sql);
    echo "✅ Schema applied successfully\n";
} catch (PDOException $e) {
    echo "⚠️  Schema: " . $e->getMessage() . "\n";
}

// Create admin user with proper password hash
$adminPassword = 'admin123';
$hash = password_hash($adminPassword, PASSWORD_BCRYPT);

try {
    $db->exec("UPDATE users SET password = '$hash' WHERE username = 'admin'");
    echo "✅ Admin password set\n";
} catch (PDOException $e) {
    echo "⚠️  Admin update: " . $e->getMessage() . "\n";
}

echo "\n✅ Database created: $dbFile\n";
echo "✅ Admin user: admin / $adminPassword\n";
echo "\n🔒 IMPORTANT: Change the admin password after first login!\n";
echo "\nDone! Start the server with:\n";
echo "  php -S localhost:8080 -t www\n\n";
