<?php
// source: /Users/jansuchanek/Sites/public/suchanek/petrdivis/config/common.neon
// source: array

/** @noinspection PhpParamsInspection,PhpMethodMayBeStaticInspection */

declare(strict_types=1);

class Container_fc21449126 extends Nette\DI\Container
{
	protected array $tags = [
		'nette.inject' => [
			'application.1' => true,
			'application.2' => true,
			'application.3' => true,
			'application.4' => true,
			'application.5' => true,
		],
	];

	protected array $aliases = [
		'application' => 'application.application',
		'cacheStorage' => 'cache.storage',
		'database.default' => 'database.default.connection',
		'database.default.context' => 'database.default.explorer',
		'httpRequest' => 'http.request',
		'httpResponse' => 'http.response',
		'nette.cacheJournal' => 'cache.journal',
		'nette.database.default' => 'database.default',
		'nette.database.default.context' => 'database.default.explorer',
		'nette.httpRequestFactory' => 'http.requestFactory',
		'nette.latteFactory' => 'latte.latteFactory',
		'nette.mailer' => 'mail.mailer',
		'nette.presenterFactory' => 'application.presenterFactory',
		'nette.templateFactory' => 'latte.templateFactory',
		'nette.userStorage' => 'security.userStorage',
		'session' => 'session.session',
		'user' => 'security.user',
	];

	protected array $wiring = [
		'Nette\DI\Container' => [['container']],
		'Nette\Application\Application' => [['application.application']],
		'Nette\Application\IPresenterFactory' => [['application.presenterFactory']],
		'Nette\Application\LinkGenerator' => [['application.linkGenerator']],
		'Nette\Caching\Storages\Journal' => [['cache.journal']],
		'Nette\Caching\Storage' => [['cache.storage']],
		'Nette\Database\Connection' => [['database.default.connection']],
		'Nette\Database\IStructure' => [['database.default.structure']],
		'Nette\Database\Structure' => [['database.default.structure']],
		'Nette\Database\Conventions' => [['database.default.conventions']],
		'Nette\Database\Conventions\DiscoveredConventions' => [['database.default.conventions']],
		'Nette\Database\Explorer' => [['database.default.explorer']],
		'Nette\Http\RequestFactory' => [['http.requestFactory']],
		'Nette\Http\IRequest' => [['http.request']],
		'Nette\Http\Request' => [['http.request']],
		'Nette\Http\IResponse' => [['http.response']],
		'Nette\Http\Response' => [['http.response']],
		'Nette\Bridges\ApplicationLatte\LatteFactory' => [['latte.latteFactory']],
		'Nette\Application\UI\TemplateFactory' => [['latte.templateFactory']],
		'Nette\Bridges\ApplicationLatte\TemplateFactory' => [['latte.templateFactory']],
		'Nette\Mail\Mailer' => [['mail.mailer']],
		'Nette\Security\Passwords' => [['security.passwords']],
		'Nette\Security\UserStorage' => [['security.userStorage']],
		'Nette\Security\User' => [['security.user']],
		'Nette\Http\Session' => [['session.session']],
		'Tracy\ILogger' => [['tracy.logger']],
		'Tracy\BlueScreen' => [['tracy.blueScreen']],
		'Tracy\Bar' => [['tracy.bar']],
		'Nette\Security\Authenticator' => [['01']],
		'Nette\Security\IAuthenticator' => [['01']],
		'App\Model\Authenticator' => [['01']],
		'App\Model\ServiceRepository' => [['02']],
		'App\Model\ServiceCategoryRepository' => [['03']],
		'App\Model\BookingRepository' => [['04']],
		'App\Model\MessageRepository' => [['05']],
		'App\Model\EmailRepository' => [['06']],
		'App\Model\UserRepository' => [['07']],
		'App\Model\AuditLogRepository' => [['08']],
		'Nette\Localization\Translator' => [['translator']],
		'App\Model\Translator' => [['translator']],
		'Nette\Routing\Router' => [['09']],
		'Nette\Application\UI\Presenter' => [2 => ['application.1', 'application.2', 'application.3']],
		'Nette\Application\UI\Control' => [2 => ['application.1', 'application.2', 'application.3']],
		'Nette\Application\UI\Component' => [2 => ['application.1', 'application.2', 'application.3']],
		'Nette\ComponentModel\Container' => [2 => ['application.1', 'application.2', 'application.3']],
		'Nette\ComponentModel\Component' => [2 => ['application.1', 'application.2', 'application.3']],
		'Nette\Application\IPresenter' => [
			2 => ['application.1', 'application.2', 'application.3', 'application.4', 'application.5'],
		],
		'Nette\Application\UI\Renderable' => [2 => ['application.1', 'application.2', 'application.3']],
		'ArrayAccess' => [2 => ['application.1', 'application.2', 'application.3']],
		'Nette\Application\UI\StatePersistent' => [2 => ['application.1', 'application.2', 'application.3']],
		'Nette\Application\UI\SignalReceiver' => [2 => ['application.1', 'application.2', 'application.3']],
		'Nette\ComponentModel\IContainer' => [2 => ['application.1', 'application.2', 'application.3']],
		'Nette\ComponentModel\IComponent' => [2 => ['application.1', 'application.2', 'application.3']],
		'App\UI\Homepage\HomepagePresenter' => [2 => ['application.1']],
		'App\UI\Admin\AdminPresenter' => [2 => ['application.2']],
		'App\UI\Sign\SignPresenter' => [2 => ['application.3']],
		'NetteModule\ErrorPresenter' => [2 => ['application.4']],
		'NetteModule\MicroPresenter' => [2 => ['application.5']],
	];


	public function __construct(array $params = [])
	{
		parent::__construct($params);
	}


	public function createService01(): App\Model\Authenticator
	{
		return new App\Model\Authenticator($this->getService('database.default.explorer'), $this->getService('security.passwords'));
	}


	public function createService02(): App\Model\ServiceRepository
	{
		return new App\Model\ServiceRepository($this->getService('database.default.explorer'));
	}


	public function createService03(): App\Model\ServiceCategoryRepository
	{
		return new App\Model\ServiceCategoryRepository($this->getService('database.default.explorer'));
	}


	public function createService04(): App\Model\BookingRepository
	{
		return new App\Model\BookingRepository($this->getService('database.default.explorer'));
	}


	public function createService05(): App\Model\MessageRepository
	{
		return new App\Model\MessageRepository($this->getService('database.default.explorer'));
	}


	public function createService06(): App\Model\EmailRepository
	{
		return new App\Model\EmailRepository($this->getService('database.default.explorer'));
	}


	public function createService07(): App\Model\UserRepository
	{
		return new App\Model\UserRepository($this->getService('database.default.explorer'));
	}


	public function createService08(): App\Model\AuditLogRepository
	{
		return new App\Model\AuditLogRepository($this->getService('database.default.explorer'));
	}


	public function createService09(): Nette\Routing\Router
	{
		return App\Core\RouterFactory::createRouter();
	}


	public function createServiceApplication__1(): App\UI\Homepage\HomepagePresenter
	{
		$service = new App\UI\Homepage\HomepagePresenter(
			$this->getService('02'),
			$this->getService('03'),
			$this->getService('04'),
			$this->getService('05'),
			$this->getService('06'),
			$this->getService('08'),
			$this->getService('mail.mailer'),
			$this->getService('translator'),
		);
		$service->injectPrimary(
			$this->getService('http.request'),
			$this->getService('http.response'),
			$this->getService('application.presenterFactory'),
			$this->getService('09'),
			$this->getService('session.session'),
			$this->getService('security.user'),
			$this->getService('latte.templateFactory'),
		);
		$service->injectSiteConfig($this);
		$service->invalidLinkMode = 5;
		return $service;
	}


	public function createServiceApplication__2(): App\UI\Admin\AdminPresenter
	{
		$service = new App\UI\Admin\AdminPresenter(
			$this->getService('02'),
			$this->getService('03'),
			$this->getService('04'),
			$this->getService('05'),
			$this->getService('06'),
		);
		$service->injectPrimary(
			$this->getService('http.request'),
			$this->getService('http.response'),
			$this->getService('application.presenterFactory'),
			$this->getService('09'),
			$this->getService('session.session'),
			$this->getService('security.user'),
			$this->getService('latte.templateFactory'),
		);
		$service->invalidLinkMode = 5;
		return $service;
	}


	public function createServiceApplication__3(): App\UI\Sign\SignPresenter
	{
		$service = new App\UI\Sign\SignPresenter;
		$service->injectPrimary(
			$this->getService('http.request'),
			$this->getService('http.response'),
			$this->getService('application.presenterFactory'),
			$this->getService('09'),
			$this->getService('session.session'),
			$this->getService('security.user'),
			$this->getService('latte.templateFactory'),
		);
		$service->invalidLinkMode = 5;
		return $service;
	}


	public function createServiceApplication__4(): NetteModule\ErrorPresenter
	{
		return new NetteModule\ErrorPresenter($this->getService('tracy.logger'));
	}


	public function createServiceApplication__5(): NetteModule\MicroPresenter
	{
		return new NetteModule\MicroPresenter($this, $this->getService('http.request'), $this->getService('09'));
	}


	public function createServiceApplication__application(): Nette\Application\Application
	{
		$service = new Nette\Application\Application(
			$this->getService('application.presenterFactory'),
			$this->getService('09'),
			$this->getService('http.request'),
			$this->getService('http.response'),
		);
		Nette\Bridges\ApplicationDI\ApplicationExtension::initializeBlueScreenPanel(
			$this->getService('tracy.blueScreen'),
			$service,
		);
		$this->getService('tracy.bar')->addPanel(new Nette\Bridges\ApplicationTracy\RoutingPanel(
			$this->getService('09'),
			$this->getService('http.request'),
			$this->getService('application.presenterFactory'),
		));
		return $service;
	}


	public function createServiceApplication__linkGenerator(): Nette\Application\LinkGenerator
	{
		return new Nette\Application\LinkGenerator(
			$this->getService('09'),
			$this->getService('http.request')->getUrl()->withoutUserInfo(),
			$this->getService('application.presenterFactory'),
		);
	}


	public function createServiceApplication__presenterFactory(): Nette\Application\IPresenterFactory
	{
		$service = new Nette\Application\PresenterFactory(new Nette\Bridges\ApplicationDI\PresenterFactoryCallback(
			$this,
			5,
			'/Users/jansuchanek/Sites/public/suchanek/petrdivis/temp/cache/nette.application/touch',
		));
		$service->setMapping(['*' => 'App\UI\*\**Presenter']);
		return $service;
	}


	public function createServiceCache__journal(): Nette\Caching\Storages\Journal
	{
		return new Nette\Caching\Storages\SQLiteJournal('/Users/jansuchanek/Sites/public/suchanek/petrdivis/temp/cache/journal.s3db');
	}


	public function createServiceCache__storage(): Nette\Caching\Storage
	{
		return new Nette\Caching\Storages\FileStorage(
			'/Users/jansuchanek/Sites/public/suchanek/petrdivis/temp/cache',
			$this->getService('cache.journal'),
		);
	}


	public function createServiceContainer(): Nette\DI\Container
	{
		return $this;
	}


	public function createServiceDatabase__default__connection(): Nette\Database\Connection
	{
		$service = new Nette\Database\Connection(
			'sqlite:/Users/jansuchanek/Sites/public/suchanek/petrdivis/data/database.sqlite',
			null,
			null,
			[],
		);
		Nette\Bridges\DatabaseTracy\ConnectionPanel::initialize(
			$service,
			true,
			'default',
			true,
			$this->getService('tracy.bar'),
			$this->getService('tracy.blueScreen'),
		);
		return $service;
	}


	public function createServiceDatabase__default__conventions(): Nette\Database\Conventions\DiscoveredConventions
	{
		return new Nette\Database\Conventions\DiscoveredConventions($this->getService('database.default.structure'));
	}


	public function createServiceDatabase__default__explorer(): Nette\Database\Explorer
	{
		return new Nette\Database\Explorer(
			$this->getService('database.default.connection'),
			$this->getService('database.default.structure'),
			$this->getService('database.default.conventions'),
			$this->getService('cache.storage'),
		);
	}


	public function createServiceDatabase__default__structure(): Nette\Database\Structure
	{
		return new Nette\Database\Structure($this->getService('database.default.connection'), $this->getService('cache.storage'));
	}


	public function createServiceHttp__request(): Nette\Http\Request
	{
		return $this->getService('http.requestFactory')->fromGlobals();
	}


	public function createServiceHttp__requestFactory(): Nette\Http\RequestFactory
	{
		$service = new Nette\Http\RequestFactory;
		$service->setProxy([]);
		return $service;
	}


	public function createServiceHttp__response(): Nette\Http\Response
	{
		$service = new Nette\Http\Response;
		$service->cookieSecure = $this->getService('http.request')->isSecured();
		return $service;
	}


	public function createServiceLatte__latteFactory(): Nette\Bridges\ApplicationLatte\LatteFactory
	{
		return new class ($this) implements Nette\Bridges\ApplicationLatte\LatteFactory {
			public function __construct(
				private Container_fc21449126 $container,
			) {
			}


			public function create(): Latte\Engine
			{
				$service = new Latte\Engine;
				$service->setTempDirectory('/Users/jansuchanek/Sites/public/suchanek/petrdivis/temp/cache/latte');
				$service->setAutoRefresh(true);
				$service->setStrictTypes(false);
				$service->setStrictParsing(false);
				$service->enablePhpLinter(null);
				$service->setLocale(null);
				func_num_args() && $service->addExtension(new Nette\Bridges\ApplicationLatte\UIExtension(func_get_arg(0)));
				$service->addExtension(new Nette\Bridges\CacheLatte\CacheExtension($this->container->getService('cache.storage')));
				$service->addExtension(new Nette\Bridges\FormsLatte\FormsExtension);
				return $service;
			}
		};
	}


	public function createServiceLatte__templateFactory(): Nette\Bridges\ApplicationLatte\TemplateFactory
	{
		$service = new Nette\Bridges\ApplicationLatte\TemplateFactory(
			$this->getService('latte.latteFactory'),
			$this->getService('http.request'),
			$this->getService('security.user'),
			$this->getService('cache.storage'),
			null,
		);
		Nette\Bridges\ApplicationDI\LatteExtension::initLattePanel($service, $this->getService('tracy.bar'), false);
		return $service;
	}


	public function createServiceMail__mailer(): Nette\Mail\Mailer
	{
		return new Nette\Mail\SmtpMailer(
			'smtp.seznam.cz',
			'pavlina.taborska@post.cz',
			/*sensitive{*/'lang12345lang12345'/*}*/,
			465,
			'ssl',
		);
	}


	public function createServiceSecurity__passwords(): Nette\Security\Passwords
	{
		return new Nette\Security\Passwords;
	}


	public function createServiceSecurity__user(): Nette\Security\User
	{
		$service = new Nette\Security\User($this->getService('security.userStorage'), $this->getService('01'));
		$this->getService('tracy.bar')->addPanel(new Nette\Bridges\SecurityTracy\UserPanel($service));
		return $service;
	}


	public function createServiceSecurity__userStorage(): Nette\Security\UserStorage
	{
		return new Nette\Bridges\SecurityHttp\SessionStorage($this->getService('session.session'));
	}


	public function createServiceSession__session(): Nette\Http\Session
	{
		$service = new Nette\Http\Session($this->getService('http.request'), $this->getService('http.response'));
		$service->setOptions(['cookieSamesite' => 'Lax']);
		return $service;
	}


	public function createServiceTracy__bar(): Tracy\Bar
	{
		return Tracy\Debugger::getBar();
	}


	public function createServiceTracy__blueScreen(): Tracy\BlueScreen
	{
		return Tracy\Debugger::getBlueScreen();
	}


	public function createServiceTracy__logger(): Tracy\ILogger
	{
		return Tracy\Debugger::getLogger();
	}


	public function createServiceTranslator(): App\Model\Translator
	{
		return new App\Model\Translator('/Users/jansuchanek/Sites/public/suchanek/petrdivis/app');
	}


	public function initialize(): void
	{
		// di.
		(function () {
			$this->getService('tracy.bar')->addPanel(new Nette\Bridges\DITracy\ContainerPanel($this));
		})();
		// http.
		(function () {
			$response = $this->getService('http.response');
			$response->setHeader('X-Powered-By', 'Nette Framework 3');
			$response->setHeader('Content-Type', 'text/html; charset=utf-8');
			$response->setHeader('X-Frame-Options', 'SAMEORIGIN');
			Nette\Http\Helpers::initCookie($this->getService('http.request'), $response);
		})();
		// session.
		(function () {
			$this->getService('session.session')->autoStart(false);
		})();
		// tracy.
		(function () {
			if (!Tracy\Debugger::isEnabled()) { return; }
			$logger = $this->getService('tracy.logger');
			$keysToHide = [];
			array_push(Tracy\Debugger::$keysToHide, ...$keysToHide);
			array_push(Tracy\Debugger::getBlueScreen()->keysToHide, ...$keysToHide);;
			if ($logger instanceof Tracy\Logger) $logger->mailer = [
				new Tracy\Bridges\Nette\MailSender(
					$this->getService('mail.mailer'),
					null,
					$this->getByType('Nette\Http\Request', false)?->getUrl()->getHost(),
				),
				'send',
			];
		})();
	}


	protected function getStaticParameters(): array
	{
		return [
			'site' => [
				'name' => 'Instalatérské potřeby - Petr Diviš',
				'email' => 'prodejna@petrdivis.cz',
				'phone' => '+420 777 200 916',
				'address' => 'Služeb 1, 100 00 Praha 10',
				'ico' => '27943585',
			],
			'appDir' => '/Users/jansuchanek/Sites/public/suchanek/petrdivis/app',
			'wwwDir' => '/Users/jansuchanek/Sites/public/suchanek/petrdivis/www',
			'vendorDir' => '/Users/jansuchanek/Sites/public/suchanek/petrdivis/vendor',
			'rootDir' => '/Users/jansuchanek/Sites/public/suchanek/petrdivis',
			'debugMode' => true,
			'productionMode' => false,
			'consoleMode' => false,
			'tempDir' => '/Users/jansuchanek/Sites/public/suchanek/petrdivis/temp',
		];
	}


	protected function getDynamicParameter(string|int $key): mixed
	{
		return match($key) {
			'baseUrl' => rtrim($this->getService('http.request')->getUrl()->getBaseUrl(), '/'),
			default => parent::getDynamicParameter($key),
		};
	}


	public function getParameters(): array
	{
		array_map($this->getParameter(...), ['baseUrl']);
		return parent::getParameters();
	}
}
