<?php

/**
 * This file is part of the Latte (https://latte.nette.org)
 * Copyright (c) 2008 David Grudl (https://davidgrudl.com)
 */

declare(strict_types=1);

namespace Latte\Compiler\Nodes\Php\Expression;

use Latte\Compiler\Nodes\Php\ExpressionNode;
use Latte\Compiler\Nodes\Php\OperatorNode;
use Latte\Compiler\Position;
use Latte\Compiler\PrintContext;


class CloneNode extends ExpressionNode implements OperatorNode
{
	public function __construct(
		public ExpressionNode $expr,
		public ?Position $position = null,
	) {
	}


	public function print(PrintContext $context): string
	{
		return 'clone ' . $this->expr->print($context);
	}


	public function getOperatorPrecedence(): array
	{
		return [270, self::AssocNone];
	}


	public function &getIterator(): \Generator
	{
		yield $this->expr;
	}
}
