<?php

/**
 * This file is part of the Latte (https://latte.nette.org)
 * Copyright (c) 2008 David Grudl (https://davidgrudl.com)
 */

declare(strict_types=1);

namespace Latte\Compiler;

use Latte\Compiler\Nodes\Php as Node;
use Latte\Compiler\Nodes\Php\Expression;
use Latte\Compiler\Nodes\Php\Scalar;
use function array_pop, count, is_string, substr;


/** @internal generated part of TagParser */
trait TagParserData
{
	/** Symbol number of error recovery token */
	protected const ErrorSymbol = 1;

	/** Action number signifying default action */
	protected const DefaultAction = -8190;

	/** Rule number signifying that an unexpected token was encountered */
	protected const UnexpectedTokenRule = 8191;

	protected const Yy2Tblstate = 266;

	/** Number of non-leaf states */
	protected const NumNonLeafStates = 367;

	/** Map of lexer tokens to internal symbols */
	protected const TokenToSymbol = [
		0,     116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
		116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   51,    111,   116,   112,   50,    116,   116,
		105,   106,   48,    46,    2,     47,    42,    49,    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   22,    109,
		37,    7,     39,    21,    62,    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
		116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   64,    116,   110,   29,    116,   116,   103,   116,   116,
		116,   101,   104,   116,   116,   116,   116,   116,   116,   102,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
		116,   116,   116,   107,   26,    108,   53,    116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
		116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
		116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
		116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
		116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
		116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
		116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   116,   1,     3,     4,     5,
		6,     8,     9,     10,    11,    12,    13,    14,    15,    16,    17,    18,    19,    20,    23,    24,    25,    27,    28,    30,
		31,    32,    33,    34,    35,    36,    38,    40,    41,    43,    44,    45,    52,    54,    55,    56,    57,    58,    59,    60,
		61,    63,    65,    66,    67,    68,    69,    70,    71,    72,    73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
		83,    84,    85,    86,    87,    88,    89,    90,    91,    92,    93,    113,   94,    95,    96,    97,    114,   115,   98,    99,
		100,
	];

	/** Map of states to a displacement into the self::Action table. The corresponding action for this
	 *  state/symbol pair is self::Action[self::ActionBase[$state] + $symbol]. If self::ActionBase[$state] is 0, the
	 *  action is defaulted, i.e. self::ActionDefault[$state] should be used instead. */
	protected const ActionBase = [
		452,   283,   119,   283,   162,   283,   283,   201,   283,   244,   283,   327,   327,   327,   327,   -30,   -30,   -30,   -30,   -12,
		-12,   49,    232,   364,   312,   364,   312,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,
		364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,
		364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,
		364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,   364,
		364,   364,   364,   364,   364,   364,   364,   455,   56,    308,   323,   468,   471,   470,   472,   485,   486,   484,   487,   492,
		68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    282,   272,   352,   143,   143,   143,
		143,   143,   143,   143,   143,   143,   143,   143,   143,   143,   143,   143,   143,   143,   143,   298,   298,   298,   313,   482,
		476,   469,   125,   152,   152,   435,   435,   435,   435,   435,   192,   366,   366,   -35,   -35,   -35,   -35,   186,   186,   311,
		311,   311,   311,   311,   311,   311,   311,   311,   149,   302,   -10,   -10,   194,   208,   147,   147,   147,   147,   27,    27,
		27,    27,    27,    27,    27,    65,    174,   174,   174,   391,   424,   427,   440,   340,   -57,   -57,   -57,   -57,   -57,   -57,
		360,   493,   -8,    304,   304,   450,   338,   338,   126,   304,   362,   113,   139,   454,   463,   466,   234,   159,   62,    465,
		336,   345,   355,   18,    18,    467,   17,    382,   448,   448,   354,   382,   382,   382,   354,   -56,   -56,   -56,   -42,   -19,
		54,    301,   473,   301,   301,   301,   285,   -47,   418,   418,   158,   426,   426,   161,   228,   167,   418,   418,   418,   418,
		167,   255,   167,   167,   344,   330,   369,   269,   172,   369,   343,   343,   258,   130,   436,   432,   437,   423,   417,   475,
		326,   332,   358,   348,   416,   329,   436,   432,   437,   351,   22,    410,   411,   357,   357,   357,   357,   357,   357,   357,
		357,   357,   357,   326,   449,   150,   359,   439,   441,   95,    365,   456,   457,   458,   478,   350,   479,   357,   459,   384,
		328,   489,   414,   121,   326,   490,   460,   474,   356,   371,   451,   353,   491,   461,   462,   373,   480,   284,   453,   287,
		481,   299,   477,   334,   464,   488,   483,   0,     -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,
		-30,   -30,   0,     0,     0,     0,     -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,
		-30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,
		-30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,
		-30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,
		-30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   68,    68,    68,    68,    68,    68,
		68,    68,    68,    68,    68,    68,    68,    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
		68,    68,    68,    68,    68,    68,    68,    68,    68,    0,     68,    68,    68,    68,    68,    68,    68,    366,   0,     0,
		174,   174,   174,   174,   331,   331,   331,   331,   331,   331,   331,   331,   331,   331,   331,   174,   174,   331,   331,   331,
		331,   331,   331,   331,   331,   331,   331,   331,   331,   331,   331,   331,   0,     0,     0,     0,     0,     0,     0,     0,
		362,   343,   343,   343,   343,   343,   343,   362,   362,   0,     0,     0,     0,     174,   174,   0,     0,     0,     362,   343,
		0,     0,     0,     0,     0,     0,     382,   382,   382,   362,   426,   426,   354,   0,     0,     343,   343,   0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     357,   150,   357,   357,   357,
	];

	/** Table of actions. Indexed according to self::ActionBase comment. */
	protected const Action = [
		373,   372,   -8191, -8191, -8191, -8191, 68,    69,    70,    71,    72,    198,   392,   392,   393,   393,   31,    32,    -8190, -8190,
		11,    33,    -50,   34,    179,   180,   35,    36,    37,    38,    39,    40,    41,    29,    1,     194,   24,    588,   589,   209,
		12,    570,   394,   199,   200,   586,   294,   201,   251,   252,   97,    -202,  295,   296,   -47,   299,   -238,  297,   298,   213,
		178,   553,   -288,  -202,  -288,  287,   572,   571,   594,   592,   593,   49,    50,    51,    -201,  25,    -238,  -238,  -238,  -8190,
		-8190, 230,   299,   171,   172,   -238,  -201,  -22,   431,   22,    430,   52,    53,    54,    55,    -48,   -52,   56,    57,    58,
		59,    60,    61,    62,    63,    64,    65,    66,    67,    68,    69,    70,    71,    72,    73,    74,    75,    76,    77,    334,
		197,   -47,   375,   376,   374,   431,   -88,   430,   -88,   -242,  0,     78,    15,    79,    80,    81,    82,    83,    84,    85,
		86,    87,    88,    89,    90,    91,    -8190, -8190, -8190, -242,  -242,  -242,  8,     -88,   -88,   -8190, -8190, -8190, -201,  -286,
		10,    -286,  212,   13,    385,   375,   376,   374,   -288,  14,    -201,  379,   -288,  -8190, 20,    -8190, -8190, -8190, -8190, 497,
		499,   -8190, -8190, -8190, 195,   26,    351,   -8190, 205,   -235,  305,   69,    70,    71,    72,    306,   381,   240,   241,   380,
		386,   307,   308,   597,   375,   376,   374,   385,   673,   -235,  -235,  -235,  674,   94,    379,   198,   373,   372,   -235,  394,
		73,    74,    75,    76,    77,    446,   197,   195,   26,    198,   100,   205,   -88,   305,   -284,  -8190, -284,  78,    306,   381,
		240,   241,   380,   386,   307,   308,   385,   375,   376,   374,   1,     196,   45,    379,   95,    259,   94,    192,   394,   299,
		239,   586,   -8190, -8190, 394,   -286,  195,   26,    458,   -286,  205,   396,   305,   297,   298,   -8190, -8190, 306,   381,   240,
		241,   380,   386,   307,   308,   -8190, 375,   376,   374,   385,   103,   44,    431,   104,   430,   98,    379,   230,   299,   96,
		-29,   -8190, -8190, -8190, 299,   105,   431,   442,   430,   195,   26,    202,   203,   205,   16,    305,   -8190, -8190, -8190, -8190,
		306,   381,   240,   241,   380,   386,   307,   308,   385,   18,    375,   376,   374,   92,    -8190, 379,   -8190, -8190, 98,    93,
		-284,  106,   -8190, -8190, -284,  70,    71,    72,    195,   26,    448,   -23,   205,   197,   305,   -8190, -8190, -8190, -17,   306,
		381,   240,   241,   380,   386,   307,   308,   -16,   -235,  375,   376,   374,   385,   17,    102,   1,     196,   42,    43,    379,
		259,   171,   172,   394,   -8190, -8190, 586,   99,    -235,  -235,  -235,  193,   195,   26,    -8190, -8190, 205,   -235,  305,   298,
		568,   204,   570,   306,   381,   240,   241,   380,   386,   307,   308,   385,   373,   372,   101,   394,   44,    2,     379,   429,
		78,    98,    230,   299,   404,   358,   675,   572,   571,   -8190, 598,   378,   377,   -271,  394,   389,   662,   390,   -8190, -8190,
		-8190, -210,  382,   381,   384,   383,   380,   386,   387,   388,   599,   170,   248,   21,    183,   -242,  -8190, 9,     -8190, -8190,
		-8190, -8190, 284,   0,     -8190, -8190, -8190, -8191, -8191, -8191, -8191, -8191, -8190, -8190, -8190, -242,  -242,  -242,  -270,  -8190,
		-8190, -8190, 171,   172,   -201,  -8190, -8190, -8190, -239,  -269,  -8190, -237,  -8190, -8190, -8190, -8190, -201,  -8190, -8190, -8190,
		-8190, -8190, -8190, -8190, -236,  -8190, -8190, -8190, -239,  -239,  -239,  -237,  -237,  -237,  28,    -246,  -245,  -239,  -241,  -244,
		-237,  -243,  3,     4,     -236,  -236,  -236,  27,    6,     -246,  232,   7,     -245,  -236,  217,   218,   219,   23,    -241,  -241,
		-241,  46,    47,    249,   190,   -244,  191,   214,   215,   216,   255,   256,   257,   30,    250,   5,     177,   286,   247,   583,
		299,   212,   449,   541,   584,   460,   447,   459,   443,   0,     559,   -29,   0,     536,   342,   0,     347,   575,   542,   642,
		0,     19,    48,    0,     267,   0,     670,   672,   405,   671,   0,     552,   355,   669,   626,   640,   0,     366,   0,     615,
		630,   665,   360,   0,     587,
	];

	/** Table indexed analogously to self::Action. If self::ActionCheck[self::ActionBase[$state] + $symbol] != $symbol
	 *  then the action is defaulted, i.e. self::ActionDefault[$state] should be used instead. */
	protected const ActionCheck = [
		30,    31,    37,    38,    39,    40,    41,    42,    43,    44,    45,    21,    69,    69,    71,    71,    46,    47,    30,    31,
		2,     51,    0,     53,    54,    55,    56,    57,    58,    59,    60,    61,    62,    80,    64,    65,    66,    67,    68,    69,
		22,    71,    72,    26,    27,    75,    76,    30,    78,    79,    107,   93,    82,    83,    0,     112,   64,    87,    88,    89,
		6,     108,   0,     105,   2,     77,    96,    97,    98,    99,    100,   3,     4,     5,     93,    105,   84,    85,    86,    30,
		31,    111,   112,   27,    28,    93,    105,   22,    98,    21,    100,   23,    24,    25,    26,    0,     106,   29,    30,    31,
		32,    33,    34,    35,    36,    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,    47,    48,    49,    50,    70,
		52,    0,     3,     4,     5,     98,    0,     100,   2,     64,    0,     63,    7,     8,     9,     10,    11,    12,    13,    14,
		15,    16,    17,    18,    19,    20,    3,     4,     5,     84,    85,    86,    2,     27,    28,    3,     4,     5,     93,    0,
		2,     2,     106,   2,     45,    3,     4,     5,     106,   2,     105,   52,    110,   21,    2,     23,    24,    25,    26,    54,
		55,    29,    30,    31,    65,    66,    47,    74,    69,    64,    71,    42,    43,    44,    45,    76,    77,    78,    79,    80,
		81,    82,    83,    90,    3,     4,     5,     45,    69,    84,    85,    86,    73,    94,    52,    21,    30,    31,    93,    72,
		46,    47,    48,    49,    50,    106,   52,    65,    66,    21,    2,     69,    106,   71,    0,     88,    2,     63,    76,    77,
		78,    79,    80,    81,    82,    83,    45,    3,     4,     5,     64,    65,    105,   52,    22,    69,    94,    2,     72,    112,
		2,     75,    30,    31,    72,    106,   65,    66,    106,   110,   69,    2,     71,    87,    88,    3,     4,     76,    77,    78,
		79,    80,    81,    82,    83,    3,     3,     4,     5,     45,    6,     105,   98,    6,     100,   94,    52,    111,   112,   107,
		106,   3,     4,     5,     112,   6,     98,    106,   100,   65,    66,    26,    27,    69,    6,     71,    3,     4,     5,     21,
		76,    77,    78,    79,    80,    81,    82,    83,    45,    6,     3,     4,     5,     7,     21,    52,    23,    24,    94,    7,
		106,   7,     30,    31,    110,   43,    44,    45,    65,    66,    106,   22,    69,    52,    71,    3,     4,     5,     22,    76,
		77,    78,    79,    80,    81,    82,    83,    22,    64,    3,     4,     5,     45,    22,    22,    64,    65,    94,    95,    52,
		69,    27,    28,    72,    46,    47,    75,    22,    84,    85,    86,    22,    65,    66,    30,    31,    69,    93,    71,    88,
		69,    30,    71,    76,    77,    78,    79,    80,    81,    82,    83,    45,    30,    31,    64,    72,    105,   105,   52,    88,
		63,    94,    111,   112,   94,    81,    73,    96,    97,    74,    90,    65,    66,    105,   72,    69,    74,    71,    3,     4,
		5,     93,    76,    77,    78,    79,    80,    81,    82,    83,    90,    93,    93,    91,    92,    64,    21,    2,     23,    24,
		25,    26,    106,   -1,    29,    30,    31,    32,    33,    34,    35,    36,    3,     4,     5,     84,    85,    86,    105,   3,
		4,     5,     27,    28,    93,    3,     4,     5,     64,    105,   21,    64,    23,    24,    25,    26,    105,   21,    29,    23,
		24,    25,    26,    21,    64,    23,    24,    25,    84,    85,    86,    84,    85,    86,    64,    105,   105,   93,    64,    105,
		93,    105,   105,   105,   84,    85,    86,    64,    105,   105,   64,    105,   105,   93,    84,    85,    86,    105,   84,    85,
		86,    105,   105,   93,    105,   105,   105,   84,    85,    86,    84,    85,    86,    101,   102,   103,   104,   106,   105,   110,
		112,   106,   106,   106,   106,   106,   106,   106,   106,   -1,    106,   106,   -1,    106,   106,   -1,    106,   106,   106,   106,
		-1,    107,   107,   -1,    107,   -1,    108,   108,   108,   108,   -1,    108,   108,   108,   108,   108,   -1,    109,   -1,    110,
		110,   110,   110,   -1,    111,
	];

	/** Map of states to their default action */
	protected const ActionDefault = [
		8191,  282,   8191,  282,   8191,  31,    282,   8191,  282,   8191,  29,    8191,  8191,  29,    29,    8191,  8191,  8191,  8191,  39,
		29,    8191,  8191,  8191,  8191,  8191,  10,    233,   233,   233,   8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  94,    8191,  8191,  8191,  8191,  8191,
		29,    8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  283,   283,   8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,
		1,     289,   290,   97,    86,    234,   285,   287,   89,    90,    96,    43,    44,    56,    136,   138,   172,   137,   111,   117,
		118,   119,   120,   121,   122,   123,   124,   125,   126,   127,   128,   129,   109,   110,   184,   173,   171,   170,   134,   135,
		139,   142,   108,   140,   141,   159,   160,   157,   158,   161,   8191,  8191,  8191,  162,   163,   164,   165,   8191,  8191,  8191,
		8191,  8191,  8191,  8191,  8191,  8191,  8191,  8191,  166,   143,   71,    71,    71,    8191,  8191,  11,    8191,  8191,  8191,  8191,
		8191,  8191,  8191,  8191,  8191,  224,   149,   150,   152,   224,   189,   223,   168,   8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  8191,  229,   131,   133,   207,   144,   145,   235,   112,   8191,  8191,  8191,  228,   8191,  297,   235,   235,   235,   34,
		34,    34,    8191,  104,   104,   8191,  57,    34,    8191,  8191,  8191,  34,    34,    34,    2,     8191,  8191,  8191,  213,   242,
		235,   155,   8191,  146,   147,   148,   59,    8191,  200,   8191,  28,    188,   8191,  28,    28,    28,    8191,  255,   256,   257,
		28,    28,    28,    28,    191,   36,    73,    28,    28,    73,    8191,  8191,  28,    8191,  8191,  8191,  8191,  8191,  8191,  8191,
		8191,  218,   8191,  240,   253,   203,   15,    20,    21,    8191,  218,   239,   237,   153,   154,   156,   176,   177,   178,   179,
		180,   181,   182,   280,   8191,  276,   206,   8191,  8191,  235,   8191,  8191,  8191,  8191,  296,   8191,  235,   151,   8191,  214,
		260,   8191,  236,   235,   281,   8191,  8191,  8191,  8191,  60,    8191,  8191,  8191,  8191,  8191,  215,   8191,  8191,  8191,  8191,
		8191,  8191,  8191,  55,    8191,  8191,  8191,
	];

	/** Map of non-terminals to a displacement into the self::Goto table. The corresponding goto state for this
	 *  non-terminal/state pair is self::Goto[self::GotoBase[$nonTerminal] + $state] (unless defaulted) */
	protected const GotoBase = [
		0,     0,     -1,    0,     0,     0,     105,   0,     260,   -62,   58,    -28,   0,     102,   61,    0,     0,     0,     0,     229,
		239,   95,    -22,   266,   -11,   86,    0,     88,    0,     117,   93,    0,     0,     -66,   28,    34,    274,   295,   0,     0,
		110,   4,     -266,  0,     0,     53,    67,    0,     54,    0,     0,     168,   5,     0,     0,     0,     68,    0,     0,     0,
		0,     -78,   -51,   0,     0,     0,     27,    38,    106,   57,    69,    18,    0,     0,     -16,   11,    0,     8,     2,     169,
		45,    0,     0,
	];

	/** Table of states to goto after reduction. Indexed according to self::GotoBase comment. */
	protected const Goto = [
		110,   107,   110,   565,   109,   110,   451,   110,   262,   109,   566,   617,   618,   619,   138,   126,   127,   126,   123,   123,
		115,   136,   123,   483,   108,   483,   125,   125,   125,   120,   313,   314,   261,   315,   316,   317,   318,   319,   320,   321,
		322,   121,   122,   111,   112,   113,   114,   116,   134,   135,   137,   155,   158,   159,   160,   161,   163,   164,   165,   166,
		167,   168,   169,   173,   174,   175,   176,   188,   189,   206,   207,   208,   226,   227,   263,   264,   265,   337,   139,   140,
		141,   142,   143,   144,   145,   146,   147,   148,   149,   150,   151,   152,   153,   128,   156,   117,   118,   128,   129,   130,
		119,   157,   131,   154,   132,   133,   181,   399,   181,   333,   181,   181,   400,   181,   338,   181,   326,   326,   326,   326,
		185,   186,   187,   186,   428,   428,   428,   428,   567,   567,   567,   567,   428,   428,   428,   428,   428,   428,   428,   569,
		569,   569,   569,   569,   569,   569,   569,   569,   569,   569,   569,   569,   569,   569,   340,   260,   343,   223,   224,   236,
		329,   336,   228,   229,   237,   238,   310,   310,   585,   585,   585,   585,   585,   585,   585,   585,   585,   644,   629,   629,
		629,   629,   311,   311,   311,   311,   311,   311,   311,   311,   311,   311,   311,   666,   667,   668,   345,   365,   641,   641,
		641,   641,   641,   641,   608,   608,   608,   608,   608,   608,   608,   608,   608,   608,   608,   605,   605,   605,   605,   605,
		605,   605,   605,   605,   605,   605,   278,   279,   631,   632,   633,   231,   627,   627,   312,   312,   312,   312,   312,   312,
		312,   312,   312,   312,   312,   346,   462,   353,   242,   409,   272,   534,   354,   418,   473,   472,   634,   635,   660,   361,
		407,   309,   332,   309,   560,   309,   309,   323,   309,   323,   309,   235,   323,   413,   323,   660,   661,   350,   235,   235,
		421,   280,   182,   182,   344,   282,   283,   661,   235,   235,   676,   425,   432,   434,   436,   433,   435,   437,   466,   221,
		235,   327,   328,   467,   450,   554,   554,   468,   452,   445,   441,   470,   327,   328,   285,   561,   0,     362,   0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     402,   402,   402,   0,     363,   563,   0,     0,     402,   0,     0,     0,     402,   402,   402,   0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     339,   243,   244,   0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     416,   416,
	];

	/** Table indexed analogously to self::Goto. If self::GotoCheck[self::GotoBase[$nonTerminal] + $state] != $nonTerminal
	 *  then the goto state is defaulted, i.e. self::GotoDefault[$nonTerminal] should be used. */
	protected const GotoCheck = [
		2,     2,     2,     42,    2,     2,     41,    2,     78,    2,     42,    42,    42,    42,    2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     6,     13,    6,     68,    6,     6,     13,    6,     40,    6,     61,    61,    61,    61,
		6,     6,     6,     6,     33,    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,    62,
		62,    62,    62,    62,    62,    62,    62,    62,    62,    62,    62,    62,    62,    62,    74,    22,    22,    22,    22,    22,
		22,    22,    22,    22,    22,    22,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,    79,    74,    74,
		74,    74,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,    9,     9,     9,     51,    51,    74,    74,
		74,    74,    74,    74,    66,    66,    66,    66,    66,    66,    66,    66,    66,    66,    66,    67,    67,    67,    67,    67,
		67,    67,    67,    67,    67,    67,    75,    75,    75,    75,    75,    71,    74,    74,    69,    69,    69,    69,    69,    69,
		69,    69,    69,    69,    69,    11,    11,    11,    71,    19,    48,    48,    11,    11,    11,    11,    77,    77,    80,    11,
		11,    8,     20,    8,     11,    8,     8,     23,    8,     23,    8,     10,    23,    21,    23,    80,    80,    25,    10,    10,
		27,    36,    6,     6,     23,    36,    36,    80,    10,    10,    10,    30,    30,    30,    30,    30,    30,    30,    45,    70,
		10,    14,    14,    45,    37,    35,    35,    45,    37,    37,    29,    46,    14,    14,    14,    56,    -1,    34,    -1,    -1,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
		-1,    -1,    -1,    -1,    6,     6,     6,     -1,    10,    10,    -1,    -1,    6,     -1,    -1,    -1,    6,     6,     6,     -1,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
		-1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    8,     8,     8,     -1,    -1,    -1,    -1,    -1,    -1,    -1,
		-1,    -1,    -1,    23,    23,
	];

	/** Map of non-terminals to the default state to goto after their reduction */
	protected const GotoDefault = [
		-8192, 293,   124,   254,   370,   371,   184,   391,   330,   639,   625,   397,   270,   646,   291,   290,   481,   356,   288,   408,
		357,   412,   162,   300,   301,   348,   281,   420,   253,   439,   246,   266,   349,   268,   359,   474,   275,   444,   482,   273,
		331,   454,   564,   274,   245,   465,   469,   480,   271,   550,   289,   341,   210,   557,   364,   292,   562,   616,   269,   302,
		276,   576,   258,   225,   303,   -8192, 233,   222,   324,   211,   220,   659,   234,   304,   614,   277,   621,   628,   325,   645,
		658,   335,   352,
	];

	/** Map of rules to the non-terminal on their left-hand side, i.e. the non-terminal to use for
	 *  determining the state to goto after reduction. */
	protected const RuleToNonTerminal = [
		0,     1,     1,     1,     1,     6,     6,     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
		7,     7,     8,     8,     8,     9,     9,     10,    11,    11,    4,     4,     12,    12,    14,    14,    15,    15,    16,    17,
		17,    18,    18,    19,    19,    5,     5,     21,    21,    21,    21,    25,    25,    26,    26,    27,    27,    29,    29,    29,
		29,    30,    30,    30,    30,    31,    31,    31,    31,    32,    32,    28,    28,    34,    34,    35,    35,    36,    36,    38,
		38,    38,    38,    39,    39,    39,    37,    37,    41,    41,    41,    42,    42,    42,    40,    20,    43,    43,    44,    44,
		3,     3,     45,    45,    46,    46,    46,    46,    2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
		2,     2,     2,     2,     2,     2,     2,     52,    53,    47,    47,    50,    50,    54,    55,    55,    56,    57,    57,    57,
		61,    33,    33,    62,    62,    62,    48,    48,    48,    59,    59,    65,    65,    66,    67,    67,    24,    69,    69,    69,
		69,    49,    49,    49,    49,    49,    49,    49,    49,    49,    49,    49,    49,    51,    51,    64,    64,    64,    64,    64,
		72,    72,    72,    58,    58,    58,    58,    73,    73,    73,    73,    73,    73,    22,    22,    22,    22,    22,    74,    74,
		77,    76,    63,    63,    63,    63,    63,    63,    63,    60,    60,    60,    75,    75,    75,    23,    68,    78,    78,    79,
		79,    79,    79,    13,    13,    13,    13,    13,    13,    13,    13,    70,    70,    70,    70,    71,    81,    80,    80,    80,
		80,    80,    80,    80,    80,    80,    82,    82,    82,    82,
	];

	/** Map of rules to the length of their right-hand side, which is the number of elements that have to
	 *  be popped from the stack(s) on reduction. */
	protected const RuleToLength = [
		1,     2,     2,     2,     2,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
		1,     1,     1,     1,     1,     1,     1,     1,     0,     1,     2,     0,     1,     3,     0,     1,     0,     1,     7,     0,
		2,     1,     3,     3,     4,     1,     3,     1,     2,     1,     1,     2,     0,     1,     3,     4,     6,     1,     2,     1,
		1,     1,     1,     1,     1,     3,     3,     3,     3,     3,     3,     0,     1,     0,     2,     2,     4,     1,     3,     2,
		4,     4,     3,     3,     1,     3,     1,     1,     2,     2,     3,     2,     4,     3,     1,     2,     3,     1,     2,     2,
		1,     2,     3,     3,     0,     3,     3,     1,     1,     3,     3,     3,     4,     1,     1,     2,     2,     3,     3,     3,
		3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     2,     2,     2,     2,     3,     3,     3,     3,     3,     3,
		3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     2,     2,     2,     2,     3,     3,     3,
		3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     5,     4,     3,     3,     4,     4,     2,     2,     2,     2,
		2,     2,     2,     1,     8,     12,    9,     3,     2,     1,     1,     0,     4,     2,     1,     3,     2,     2,     2,     4,
		1,     1,     1,     1,     1,     1,     1,     1,     3,     1,     1,     0,     1,     1,     3,     5,     3,     4,     1,     1,
		3,     1,     1,     1,     1,     1,     1,     1,     1,     1,     3,     2,     3,     0,     1,     1,     3,     1,     1,     1,
		1,     1,     1,     1,     3,     1,     1,     1,     4,     1,     4,     4,     4,     1,     1,     3,     3,     3,     1,     4,
		1,     3,     1,     4,     3,     3,     3,     3,     3,     1,     3,     1,     1,     3,     1,     4,     1,     3,     1,     1,
		1,     3,     0,     1,     2,     3,     4,     3,     4,     2,     2,     2,     2,     1,     2,     1,     1,     1,     4,     3,
		3,     3,     3,     3,     6,     3,     1,     1,     2,     1,
	];

	/** Map of symbols to their names */
	protected const SymbolToName = [
		'end',
		'error',
		"','",
		"'or'",
		"'xor'",
		"'and'",
		"'=>'",
		"'='",
		"'+='",
		"'-='",
		"'*='",
		"'/='",
		"'.='",
		"'%='",
		"'&='",
		"'|='",
		"'^='",
		"'<<='",
		"'>>='",
		"'**='",
		"'??='",
		"'?'",
		"':'",
		"'??'",
		"'||'",
		"'&&'",
		"'|'",
		"'|'",
		"'?|'",
		"'^'",
		"'&'",
		"'&'",
		"'=='",
		"'!='",
		"'==='",
		"'!=='",
		"'<=>'",
		"'<'",
		"'<='",
		"'>'",
		"'>='",
		"'|>'",
		"'.'",
		"'<<'",
		"'>>'",
		"'in'",
		"'+'",
		"'-'",
		"'*'",
		"'/'",
		"'%'",
		"'!'",
		"'instanceof'",
		"'~'",
		"'++'",
		"'--'",
		"'(int)'",
		"'(float'",
		"'(string)'",
		"'(array)'",
		"'(object)'",
		"'(bool)'",
		"'@'",
		"'**'",
		"'['",
		"'new'",
		"'clone'",
		'integer',
		'floating-point number',
		'identifier',
		'variable name',
		'constant',
		'variable',
		'number',
		'string content',
		'quoted string',
		"'match'",
		"'default'",
		"'function'",
		"'fn'",
		"'return'",
		"'use'",
		"'isset'",
		"'empty'",
		"'->'",
		"'?->'",
		"'??->'",
		"'list'",
		"'array'",
		"'heredoc start'",
		"'heredoc end'",
		"'\${'",
		"'{\$'",
		"'::'",
		"'...'",
		"'(expand)'",
		'fully qualified name',
		'namespaced name',
		"'null'",
		"'true'",
		"'false'",
		"'e'",
		"'m'",
		"'a'",
		"'f'",
		"'('",
		"')'",
		"'{'",
		"'}'",
		"';'",
		"']'",
		"'\"'",
		"'$'",
		"'\\\\'",
		'whitespace',
		'comment',
	];

	/** Temporary value containing the result of last semantic action (reduction) */
	protected mixed $semValue = null;

	/** Semantic value stack (contains values of tokens and semantic action results) */
	protected array $semStack;

	/** @var Token[] Start attribute stack */
	protected array $startTokenStack;


	protected function reduce(int $rule, int $pos): void
	{
		(match ($rule) {
			0, 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 28, 29, 57, 72, 74, 87, 107, 108, 113, 114, 183, 189, 190, 200, 202, 206, 207, 209, 210, 212, 223, 228, 229, 234, 235, 237, 238, 239, 240, 241, 243, 245, 246, 247, 249, 253, 254, 258, 262, 269, 271, 272, 274, 279, 297, 309 => fn() => $this->semValue = $this->semStack[$pos],
			2 => fn() => $this->semValue = new Node\ModifierNode($this->semStack[$pos], position: $this->startTokenStack[$pos]->position),
			3 => fn() => $this->semValue = new Expression\ArrayNode($this->semStack[$pos], position: $this->startTokenStack[$pos]->position),
			22, 23, 24, 25, 26, 62, 63, 64 => fn() => $this->semValue = new Node\IdentifierNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			27 => fn() => $this->semValue = new Expression\VariableNode(substr($this->semStack[$pos], 1), $this->startTokenStack[$pos]->position),
			30, 40, 51, 95, 105, 106, 168, 169, 192, 193, 208, 236, 244, 270, 273, 305 => fn() => $this->semValue = $this->semStack[$pos - 1],
			31, 39, 52, 75, 79, 91, 104, 191, 211 => fn() => $this->semValue = [],
			32, 41, 53, 77, 84, 97, 100, 194, 278, 293 => fn() => $this->semValue = [$this->semStack[$pos]],
			33, 42, 54, 66, 68, 70, 78, 85, 96, 195, 277 => function () use ($pos) {
				$this->semStack[$pos - 2][] = $this->semStack[$pos];
				$this->semValue = $this->semStack[$pos - 2];
			},
			34, 36 => fn() => $this->semValue = false,
			35, 37 => fn() => $this->semValue = true,
			38 => fn() => $this->semValue = new Expression\MatchNode($this->semStack[$pos - 4], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 6]->position),
			43 => fn() => $this->semValue = new Node\MatchArmNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			44 => fn() => $this->semValue = new Node\MatchArmNode(null, $this->semStack[$pos], $this->startTokenStack[$pos - 3]->position),
			45 => fn() => $this->semValue = [null, ...$this->semStack[$pos]],
			46 => fn() => $this->semValue = [$this->semStack[$pos - 2], ...$this->semStack[$pos]],
			47, 49 => fn() => $this->semValue = [$this->semStack[$pos], false],
			48 => fn() => $this->semValue = [$this->semStack[$pos], true],
			50 => fn() => $this->semValue = [$this->convertArrayToList($this->semStack[$pos]), false],
			55 => fn() => $this->semValue = new Node\ParameterNode($this->semStack[$pos], null, $this->semStack[$pos - 3], $this->semStack[$pos - 2], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			56 => fn() => $this->semValue = new Node\ParameterNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->semStack[$pos - 5], $this->semStack[$pos - 4], $this->semStack[$pos - 3], $this->startTokenStack[$pos - 5]->position),
			58 => fn() => $this->semValue = new Node\NullableTypeNode($this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			59 => fn() => $this->semValue = new Node\UnionTypeNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			60 => fn() => $this->semValue = new Node\IntersectionTypeNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			61 => fn() => $this->semValue = TagParser::handleBuiltinTypes($this->semStack[$pos]),
			65, 67, 69 => fn() => $this->semValue = [$this->semStack[$pos - 2], $this->semStack[$pos]],
			71, 73, 233 => fn() => $this->semValue = null,
			76, 80, 92 => fn() => $this->semValue = $this->semStack[$pos - 2],
			81 => fn() => $this->semValue = [new Node\ArgumentNode($this->semStack[$pos - 2], false, false, null, $this->startTokenStack[$pos - 3]->position)],
			82, 93 => fn() => $this->semValue = [$this->semStack[$pos - 1]],
			83 => fn() => $this->semValue = [new Node\ArgumentNode($this->semStack[$pos - 2], false, false, null, $this->startTokenStack[$pos - 2]->position), $this->semStack[$pos]],
			86 => fn() => $this->semValue = new Node\ArgumentNode($this->semStack[$pos], false, false, null, $this->startTokenStack[$pos]->position),
			88 => fn() => $this->semValue = new Node\ArgumentNode($this->semStack[$pos], true, false, null, $this->startTokenStack[$pos - 1]->position),
			89 => fn() => $this->semValue = new Node\ArgumentNode($this->semStack[$pos], false, true, null, $this->startTokenStack[$pos - 1]->position),
			90 => fn() => $this->semValue = new Node\ArgumentNode($this->semStack[$pos], false, false, $this->semStack[$pos - 2], $this->startTokenStack[$pos - 2]->position),
			94 => fn() => $this->semValue = new Node\VariadicPlaceholderNode($this->startTokenStack[$pos]->position),
			98, 99 => fn() => $this->semValue = new Expression\FilterCallNode($this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			101, 291, 292 => function () use ($pos) {
				$this->semStack[$pos - 1][] = $this->semStack[$pos];
				$this->semValue = $this->semStack[$pos - 1];
			},
			102 => fn() => $this->semValue = new Node\FilterNode($this->semStack[$pos - 1], $this->semStack[$pos], false, $this->startTokenStack[$pos - 2]->position),
			103 => fn() => $this->semValue = new Node\FilterNode($this->semStack[$pos - 1], $this->semStack[$pos], true, $this->startTokenStack[$pos - 2]->position),
			109, 111 => fn() => $this->semValue = new Expression\AssignNode($this->semStack[$pos - 2], $this->semStack[$pos], false, $this->startTokenStack[$pos - 2]->position),
			110 => fn() => $this->semValue = new Expression\AssignNode($this->convertArrayToList($this->semStack[$pos - 2]), $this->semStack[$pos], false, $this->startTokenStack[$pos - 2]->position),
			112 => fn() => $this->semValue = new Expression\AssignNode($this->semStack[$pos - 3], $this->semStack[$pos], true, $this->startTokenStack[$pos - 3]->position),
			115 => fn() => $this->semValue = new Expression\FunctionCallNode(new Node\NameNode($this->semStack[$pos - 1], Node\NameNode::KindNormal, $this->startTokenStack[$pos - 1]->position), $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			116 => fn() => $this->semValue = new Expression\CloneNode($this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			117 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '+', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			118 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '-', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			119 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '*', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			120 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '/', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			121 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '.', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			122 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '%', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			123 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '&', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			124 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '|', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			125 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '^', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			126 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '<<', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			127 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '>>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			128 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '**', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			129 => fn() => $this->semValue = new Expression\AssignOpNode($this->semStack[$pos - 2], '??', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			130 => fn() => $this->semValue = new Expression\PostOpNode($this->semStack[$pos - 1], '++', $this->startTokenStack[$pos - 1]->position),
			131 => fn() => $this->semValue = new Expression\PreOpNode($this->semStack[$pos], '++', $this->startTokenStack[$pos - 1]->position),
			132 => fn() => $this->semValue = new Expression\PostOpNode($this->semStack[$pos - 1], '--', $this->startTokenStack[$pos - 1]->position),
			133 => fn() => $this->semValue = new Expression\PreOpNode($this->semStack[$pos], '--', $this->startTokenStack[$pos - 1]->position),
			134 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '||', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			135 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '&&', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			136 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], 'or', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			137 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], 'and', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			138 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], 'xor', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			139 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '|', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			140, 141 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '&', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			142 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '^', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			143 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '.', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			144 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '+', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			145 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '-', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			146 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '*', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			147 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '/', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			148 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '%', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			149 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '<<', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			150 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '>>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			151 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '**', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			152 => fn() => $this->semValue = new Expression\InNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			153 => fn() => $this->semValue = new Expression\UnaryOpNode($this->semStack[$pos], '+', $this->startTokenStack[$pos - 1]->position),
			154 => fn() => $this->semValue = new Expression\UnaryOpNode($this->semStack[$pos], '-', $this->startTokenStack[$pos - 1]->position),
			155 => fn() => $this->semValue = new Expression\UnaryOpNode($this->semStack[$pos], '!', $this->startTokenStack[$pos - 1]->position),
			156 => fn() => $this->semValue = new Expression\UnaryOpNode($this->semStack[$pos], '~', $this->startTokenStack[$pos - 1]->position),
			157 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '===', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			158 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '!==', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			159 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '==', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			160 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '!=', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			161 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '<=>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			162 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '<', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			163 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '<=', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			164 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			165 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '>=', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			166 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '|>', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			167 => fn() => $this->semValue = new Expression\InstanceofNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			170 => fn() => $this->semValue = new Expression\TernaryNode($this->semStack[$pos - 4], $this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 4]->position),
			171 => fn() => $this->semValue = new Expression\TernaryNode($this->semStack[$pos - 3], null, $this->semStack[$pos], $this->startTokenStack[$pos - 3]->position),
			172 => fn() => $this->semValue = new Expression\TernaryNode($this->semStack[$pos - 2], $this->semStack[$pos], null, $this->startTokenStack[$pos - 2]->position),
			173 => fn() => $this->semValue = new Expression\BinaryOpNode($this->semStack[$pos - 2], '??', $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			174 => fn() => $this->semValue = new Expression\IssetNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			175 => fn() => $this->semValue = new Expression\EmptyNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			176 => fn() => $this->semValue = new Expression\CastNode('int', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			177 => fn() => $this->semValue = new Expression\CastNode('float', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			178 => fn() => $this->semValue = new Expression\CastNode('string', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			179 => fn() => $this->semValue = new Expression\CastNode('array', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			180 => fn() => $this->semValue = new Expression\CastNode('object', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			181 => fn() => $this->semValue = new Expression\CastNode('bool', $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
			182 => fn() => $this->semValue = new Expression\UnaryOpNode($this->semStack[$pos], '@', $this->startTokenStack[$pos - 1]->position),
			184 => fn() => $this->semValue = new Expression\ClosureNode((bool) $this->semStack[$pos - 6], $this->semStack[$pos - 4], [], $this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 7]->position),
			185 => fn() => $this->semValue = new Expression\ClosureNode((bool) $this->semStack[$pos - 10], $this->semStack[$pos - 8], $this->semStack[$pos - 6], $this->semStack[$pos - 5], $this->semStack[$pos - 2], $this->startTokenStack[$pos - 11]->position),
			186 => fn() => $this->semValue = new Expression\ClosureNode((bool) $this->semStack[$pos - 7], $this->semStack[$pos - 5], $this->semStack[$pos - 3], $this->semStack[$pos - 2], null, $this->startTokenStack[$pos - 8]->position),
			187 => fn() => $this->semValue = new Expression\NewNode($this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			188 => fn() => $this->semValue = new Expression\NewNode($this->semStack[$pos], [], $this->startTokenStack[$pos - 1]->position),
			196 => fn() => $this->semValue = new Node\ClosureUseNode($this->semStack[$pos], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 1]->position),
			197, 198 => fn() => $this->semValue = $this->checkFunctionName(new Expression\FunctionCallNode($this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position)),
			199 => fn() => $this->semValue = new Expression\StaticMethodCallNode($this->semStack[$pos - 3], $this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 3]->position),
			201, 204 => fn() => $this->semValue = new Node\NameNode($this->semStack[$pos], Node\NameNode::KindNormal, $this->startTokenStack[$pos]->position),
			203 => fn() => $this->semValue = new Node\NameNode($this->semStack[$pos], -1, $this->startTokenStack[$pos]->position),
			205 => fn() => $this->semValue = new Node\NameNode($this->semStack[$pos], Node\NameNode::KindFullyQualified, $this->startTokenStack[$pos]->position),
			213 => fn() => $this->semValue = new Expression\ConstantFetchNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			214 => fn() => $this->semValue = new Expression\ClassConstantFetchNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			215 => fn() => $this->semValue = new Expression\ClassConstantFetchNode($this->semStack[$pos - 4], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 4]->position),
			216 => fn() => $this->semValue = new Expression\ArrayNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 2]->position),
			217 => fn() => $this->semValue = new Expression\ArrayNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			218 => function () use ($pos) {
				$this->semValue = $this->semStack[$pos];
				$this->shortArrays->offsetSet($this->semValue);
			},
			219 => fn() => $this->semValue = Scalar\StringNode::parse($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			220 => fn() => $this->semValue = Scalar\InterpolatedStringNode::parse($this->semStack[$pos - 1], $this->startTokenStack[$pos - 2]->position),
			221 => fn() => $this->semValue = Scalar\IntegerNode::parse($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			222 => fn() => $this->semValue = Scalar\FloatNode::parse($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			224, 306 => fn() => $this->semValue = new Scalar\StringNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			225 => fn() => $this->semValue = new Scalar\BooleanNode(true, $this->startTokenStack[$pos]->position),
			226 => fn() => $this->semValue = new Scalar\BooleanNode(false, $this->startTokenStack[$pos]->position),
			227 => fn() => $this->semValue = new Scalar\NullNode($this->startTokenStack[$pos]->position),
			230 => fn() => $this->semValue = $this->parseDocString($this->semStack[$pos - 2], [$this->semStack[$pos - 1]], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position, $this->startTokenStack[$pos]->position),
			231 => fn() => $this->semValue = $this->parseDocString($this->semStack[$pos - 1], [], $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position, $this->startTokenStack[$pos]->position),
			232 => fn() => $this->semValue = $this->parseDocString($this->semStack[$pos - 2], $this->semStack[$pos - 1], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position, $this->startTokenStack[$pos]->position),
			242 => fn() => $this->semValue = new Expression\ConstantFetchNode(new Node\NameNode($this->semStack[$pos], Node\NameNode::KindNormal, $this->startTokenStack[$pos]->position), $this->startTokenStack[$pos]->position),
			248, 263, 298 => fn() => $this->semValue = new Expression\ArrayAccessNode($this->semStack[$pos - 3], $this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			250 => fn() => $this->semValue = new Expression\MethodCallNode($this->semStack[$pos - 3], $this->semStack[$pos - 1], $this->semStack[$pos], false, $this->startTokenStack[$pos - 3]->position),
			251 => fn() => $this->semValue = new Expression\MethodCallNode($this->semStack[$pos - 3], $this->semStack[$pos - 1], $this->semStack[$pos], true, $this->startTokenStack[$pos - 3]->position),
			252 => function () use ($pos) {
				$this->semValue = new Expression\MethodCallNode(new Expression\BinaryOpNode($this->semStack[$pos - 3], '??', new Scalar\NullNode($this->startTokenStack[$pos - 3]->position), $this->startTokenStack[$pos - 3]->position), $this->semStack[$pos - 1], $this->semStack[$pos], true, $this->startTokenStack[$pos - 3]->position);
				trigger_error('Latte: undefined-nullsafe operator ??-> is deprecated, used ' . $this->startTokenStack[$pos - 3]->position);
			},
			255, 264, 299 => fn() => $this->semValue = new Expression\PropertyFetchNode($this->semStack[$pos - 2], $this->semStack[$pos], false, $this->startTokenStack[$pos - 2]->position),
			256, 265, 300 => fn() => $this->semValue = new Expression\PropertyFetchNode($this->semStack[$pos - 2], $this->semStack[$pos], true, $this->startTokenStack[$pos - 2]->position),
			257, 266, 301 => function () use ($pos) {
				$this->semValue = new Expression\PropertyFetchNode(new Expression\BinaryOpNode($this->semStack[$pos - 2], '??', new Scalar\NullNode($this->startTokenStack[$pos - 2]->position), $this->startTokenStack[$pos - 2]->position), $this->semStack[$pos], true, $this->startTokenStack[$pos - 2]->position);
				trigger_error('Latte: undefined-nullsafe operator ??-> is deprecated, used ' . $this->startTokenStack[$pos - 2]->position);
			},
			259 => fn() => $this->semValue = new Expression\VariableNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position),
			260 => function () use ($pos) {
				$var = $this->semStack[$pos]->name;
				$this->semValue = is_string($var)
					? new Node\VarLikeIdentifierNode($var, $this->startTokenStack[$pos]->position)
					: $var;
			},
			261, 267, 268 => fn() => $this->semValue = new Expression\StaticPropertyFetchNode($this->semStack[$pos - 2], $this->semStack[$pos], $this->startTokenStack[$pos - 2]->position),
			275 => fn() => $this->semValue = $this->convertArrayToList(new Expression\ArrayNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 3]->position)),
			276 => function () use ($pos) {
				$this->semValue = $this->semStack[$pos];
				$end = count($this->semValue) - 1;
				if (
					$this->semValue[$end]->value instanceof Expression\TemporaryNode
					&& !$this->semValue[$end]->value->value
				) {
					array_pop($this->semValue);
				}
			},
			280 => fn() => $this->semValue = new Node\ArrayItemNode(new Expression\TemporaryNode($this->semStack[$pos], $this->startTokenStack[$pos]->position), null, false, false, $this->startTokenStack[$pos]->position),
			281 => fn() => $this->semValue = new Node\ArrayItemNode(new Expression\TemporaryNode($this->semStack[$pos], $this->startTokenStack[$pos - 2]->position), $this->semStack[$pos - 2], false, false, $this->startTokenStack[$pos - 2]->position),
			282 => fn() => $this->semValue = new Node\ArrayItemNode(new Expression\TemporaryNode(null), null, false, false, $this->startTokenStack[$pos]->position),
			283 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], null, false, false, $this->startTokenStack[$pos]->position),
			284 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], null, true, false, $this->startTokenStack[$pos - 1]->position),
			285, 287 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], $this->semStack[$pos - 2], false, false, $this->startTokenStack[$pos - 2]->position),
			286, 288 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], $this->semStack[$pos - 3], true, false, $this->startTokenStack[$pos - 3]->position),
			289, 290 => fn() => $this->semValue = new Node\ArrayItemNode($this->semStack[$pos], null, false, true, $this->startTokenStack[$pos - 1]->position),
			294 => fn() => $this->semValue = [$this->semStack[$pos - 1], $this->semStack[$pos]],
			295 => fn() => $this->semValue = new Node\InterpolatedStringPartNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			296 => fn() => $this->semValue = new Expression\VariableNode($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			302, 303 => fn() => $this->semValue = new Expression\VariableNode($this->semStack[$pos - 1], $this->startTokenStack[$pos - 2]->position),
			304 => fn() => $this->semValue = new Expression\ArrayAccessNode($this->semStack[$pos - 4], $this->semStack[$pos - 2], $this->startTokenStack[$pos - 5]->position),
			307 => fn() => $this->semValue = TagParser::parseOffset($this->semStack[$pos], $this->startTokenStack[$pos]->position),
			308 => fn() => $this->semValue = TagParser::parseOffset('-' . $this->semStack[$pos], $this->startTokenStack[$pos - 1]->position),
		})();
	}
}
